//
//  MCQueryController.h
//  MCApplication
//
//  Created by Alykhan Jetha on Mon Jul 07 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCModelEditor.h"



/*!

{
	FILTER_CONFIGURATION = {
		LABEL = "Timeblocks Filter";
		ENTITY = "Timeblock";
		TOP_MARGIN = 12;
		CRITERIAS = (
			{MENU_TITLE = "Assigned To"; 
				QUALIFIER_TYPE = "SomeQualifierView"; 
				LABEL = "Assigned To"; 
				KEY_PATH = "a.key.path"; 
				FORCED_DISPLAY = YES;
				MANDATORY = YES;
				MANDATORY_FAIL_MESSAGE = "You must enter a value for something";
				},

		);
	};
}



*/

@class MCQualifierView, BDQualifier, MCPObjectContext, MCPFetchSpecification;

@interface MCQueryController : MCModelEditor {

	IBOutlet		NSTextField			*windowLabelField;

	IBOutlet		NSScrollView		*scrollView;
	IBOutlet		NSPopUpButton		*criteriaPop;
	
	IBOutlet		NSTextField			*resultDisplayField;
	IBOutlet		NSPopUpButton		*fetchLimitPop;
	IBOutlet		NSPopUpButton		*batchSelectionPop;
	
	IBOutlet		NSButton			*displayRightAwaySwitch;

	IBOutlet		NSView				*postQualifiersKeyView;
	
	
	MCPObjectContext					*objectContext; // not retained
	MCPFetchSpecification				*fetchSpecification;
	

	NSMutableArray						*qualifierControllers;
	NSDictionary						*configurationDictionary;

	IBOutlet 		NSTextField			*qualifierNameTextField;
	IBOutlet 		NSButton			*addToFavouritesCheckbox;
	IBOutlet		NSButton			*displayBeforeFilteringCheckbox;
    IBOutlet        NSButton            *displayButton;
    IBOutlet        NSButton            *appendButton;
	IBOutlet		NSTabView			*saveDeleteTabView;

	NSString *defaultBatchSize;
}

- (void)setWindowLabel:(NSString *)string;
- (void)setConfigurationDictionary:(NSDictionary *)config;
- (NSDictionary *)configurationDictionary;

- (void)addQualifierController:(MCQualifierView *)ctl;
- (void)removeQualifierController:(MCQualifierView *)ctl;


- (void)setObjectContext:(MCPObjectContext *)conn;
- (MCPObjectContext *)objectContext;

- (void)setFetchSpecification:(MCPFetchSpecification *)fetch;
- (MCPFetchSpecification *)fetchSpecification;

	/*!
	@method fetchObjectsQualifiedByQualifierViews:
	 @discussion - Given an array of qualifier views, builds a qualifier, then uses the fetch to get the objects and returns them to you.
	 */
- (NSArray *)fetchObjectsQualifiedByQualifierViews:(NSArray *)controllers;


- (void)addQualifierViewOfType:(NSString *)aType configurationDictionary:(NSDictionary *)dict;

- (void)addCriteriaDictionary:(NSDictionary *)dict;
- (void)addCriteriaDictionaries:(NSArray *)array;

/*!
	@method checkMandatoryQualifiers
	@discussion calls addMandatoryMessageIfApplicable: on all qualifier views, if an error is returned a sheet is displayed with the error messages provided by the qualifier views. Returns right away, sheet will be displayed until user clicks ok.
*/
- (BOOL)checkMandatoryQualifiers;

- (void)clearAll;

- (BDQualifier *)buildQualifier;

- (IBAction)changeFetchLimit:(id)sender;

- (IBAction)addCriteria:(id)sender;
- (IBAction)filter:(id)sender;

- (IBAction)appendToArray:(id)sender;
- (IBAction)displayArray:(id)sender;

// Looks in configuration dictionary and sets the state(i.e. values for textfields, selected items in popups) from the keys if they exist
- (void)setStateFromConfigurationDictionary;
- (void)setConfigurationDictionaryFromState;

- (NSDictionary *)plistRepresentation;

- (void)removeAllQualifierControllers;

- (IBAction)deleteCurrentQualification:(id)sender;
- (IBAction)saveCurrentQualification:(id)sender;

- (void)resetQueryController;

// ACCESSORS
- (NSTextField *)qualifierNameTextField;
- (NSTabView *)saveDeleteTabView;
- (NSMutableArray *)qualifierControllers;
@end


@interface NSObject (MCQueryControllerDelegate)


/*!
	@method queryController:fetchedObjects:usingFetchSpecification:shouldAppend:
	@abstract informs the delegate of the fetched objects and whether those objects should be appended to the current results in the delegate.
	@param mqc - the query controller
	@param objs - objects (of the appropriate batch) fetched from the database using the fetches specification
	@param fetchSpecification - the fetch specification used to fetch the objects
	@param appendFlag - whether the user wants the objects to the appended or not
*/
- (void)queryController:(MCQueryController *)mqc 
					fetchedObjects:(NSArray *)objs 
					usingFetchSpecification:(MCPFetchSpecification *)fetchSpecification 
					shouldAppend:(BOOL)appendFlag;

	int sortDict(id string1, id string2, void *context);

/*!
	@method queryControllershouldSaveCurrentQualifier:
 	@abstract informs delegate that the query set up by the user needs to be saved
 	@param mqc The query controller
*/
- (void)queryControllerShouldSaveCurrentQualification:(MCQueryController *)mqc;
- (void)queryControllerShouldDeleteCurrentQualification:(MCQueryController *)mqc;

/*!
	Gives the delegate an opportunity to massage the criteria dictionary before it is used for anything. No replacement occurs is nil is returned. Replacement only occurs when an instance of NSDictionary is returned.
*/
- (NSDictionary	*)queryController:(MCQueryController *)mqc 
	shouldReplaceCriteriaDictionary:(NSDictionary *)crit;

- (void)filterNoUI;
@end
